%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Part of the replication package for the paper
%   "Marginal Effects for Probit and Tobit with Endogeneity"
%   by Kirill S. Evdokimov, Ilze Kalnina, and Andrei Zeleneev.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function flat_c = cell_flatten(c)
  assert(iscell(c));
  if isempty(c)
    flat_c = {}; 
    return
  end
  
  assert(iscell(c{1}));
  n_rows = numel(c);
  n_cols = numel(c{1});
  flat_c = cell(n_rows,n_cols);
  for i=1:n_rows
    for j=1:n_cols
      flat_c{i,j}=c{i}{j};
    end
  end
end
